# [ChessSolve](https://www.chesssolve.com/) Chess.com Bot

## Overview

The ChessSolve Chess.com Bot is a real-time chess game analyzer designed to read the chess board during both Bot vs Player and Player vs Player games on Chess.com. It suggests the best moves for the player based on the current game state using advanced chess engines and AI. This bot aims to assist players in making optimal moves by providing real-time analysis and move recommendations.

## Features

- Real-time Chess Board Reading: The bot scans and understands the chess board state, recognizing both Bot and Player moves.
- Best Move Suggestions: Using chess engines like Stockfish, the bot evaluates the game state and suggests the best possible move.
- Bot vs Player & Player vs Player Support: It works in both scenarios, analyzing the game in real-time, regardless of the player setup.
- Move History Tracking: Tracks and records moves during a match for analysis and replaying.
- Interactive UI: Provides an easy-to-use interface to view the chess board and suggested moves.
- Chess.com Integration: Seamlessly integrates with Chess.com for live game analysis.

## Prerequisites

Before you begin, ensure that you have met the following requirements:

- Create a chess-masters account on https://www.chesssolve.com/
- Install the extension on your browser: https://www.chesssolve.com/setup-guide

## Installation & Setup

If you want to get the source code:

```bash
git clone https://github.com/mersesarvari/chess-masters.git
cd chess-masters
```

## Usage

1. Start a Game:
   Bot vs Player: Start a game against the ChessSolve Bot on Chess.com. The bot will automatically read the chessboard and suggest moves. You have to start hte bot after every game for safety reasons.
   Player vs Player: During a game, the bot can read the board and suggest the best moves for both players.
2. Game Board Display:
   The bot will provide a visual representation of the current chess board.
   After each move, the bot will highlight the best move suggestion.
3. Move Suggestions:
   For each turn, the bot will calculate the best move using the chess engine and display it.
   The suggestions will be updated in real-time as the game progresses.
4. Move History:
   The bot keeps track of all moves and displays a move history for easy reference.
   You can check your replayes on https://www.chesssolve.com/

## Support the Developer

If you enjoy using this extension and would like to support its ongoing development, you can make a donation through Ko-fi. Your support helps keep the project alive and improve future updates!

[Support on Ko-fi](https://ko-fi.com/nazmox)

Thank you for your support! 🙏

## Contact

For further questions or issues, feel free to open an issue on GitHub or contact the maintainer at merse.sarvari@gmail.com
